/*
 * Decompiled with CFR 0.152.
 */
package de.unhappycodings.quarry.common.blockentity;

import com.mojang.authlib.GameProfile;
import de.unhappycodings.quarry.common.blockentity.ModBlockEntities;
import de.unhappycodings.quarry.common.blocks.QuarryBlock;
import de.unhappycodings.quarry.common.config.CommonConfig;
import de.unhappycodings.quarry.common.container.QuarryContainer;
import de.unhappycodings.quarry.common.item.ModItems;
import de.unhappycodings.quarry.common.util.CalcUtil;
import de.unhappycodings.quarry.common.util.NbtUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QuarryBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer,
MenuProvider {
    private static final int SPEED_0 = 15;
    private static final int SPEED_1 = 10;
    private static final int SPEED_2 = 5;
    private static final int SPEED_3 = 2;
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])Direction.values());
    public LootContext.Builder lootcontextBuilder;
    public List<BlockPos> blockStateList;
    public NonNullList<ItemStack> items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
    private int speedModifier = 0;
    private boolean isFortune = false;
    private String owner;
    private int burnTicks;
    private int ticks;
    private int speed;
    private int mode;
    private int eject;
    private boolean filter;
    private boolean loop;
    private boolean locked;
    private boolean skip;
    private int burnTime;
    private int totalBurnTime;

    public QuarryBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super((BlockEntityType)ModBlockEntities.QUARRY_BLOCK.get(), pPos, pBlockState);
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER && !this.m_58901_() && side != null) {
            return this.itemHandler[side.m_122411_()].cast();
        }
        return super.getCapability(cap, side);
    }

    private void exportImportRightSide(IItemHandler quarryHandler, boolean in) {
        BlockEntity tileRight;
        switch ((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)) {
            case NORTH: {
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122024_());
                break;
            }
            case EAST: {
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122012_());
                break;
            }
            case SOUTH: {
                BlockEntity blockEntity = this.f_58857_.m_7702_(this.m_58899_().m_122029_());
                break;
            }
            default: {
                BlockEntity blockEntity = tileRight = this.f_58857_.m_7702_(this.m_58899_().m_122019_());
            }
        }
        if (tileRight != null) {
            LazyOptional capabilityRight = tileRight.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (in && capabilityRight.isPresent()) {
                IItemHandler handlerRight = (IItemHandler)capabilityRight.resolve().get();
                for (int i = 0; i < handlerRight.getSlots(); ++i) {
                    ItemStack stack = handlerRight.getStackInSlot(i);
                    if (!(stack.m_41720_() instanceof BlockItem)) {
                        return;
                    }
                    if (!quarryHandler.getStackInSlot(13).m_150930_(stack.m_41720_()) && !quarryHandler.getStackInSlot(13).m_150930_(Items.f_41852_) || quarryHandler.getStackInSlot(13).m_41613_() >= quarryHandler.getStackInSlot(13).m_41741_()) continue;
                    quarryHandler.insertItem(13, new ItemStack((ItemLike)stack.m_41720_(), 1), false);
                    handlerRight.extractItem(i, 1, false);
                    break;
                }
            }
        }
    }

    private void exportImportAbove(IItemHandler quarryHandler, boolean in) {
        BlockEntity tileAbove = this.f_58857_.m_7702_(this.m_58899_().m_7494_());
        if (tileAbove != null) {
            LazyOptional capabilityAbove = tileAbove.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (in && capabilityAbove.isPresent()) {
                IItemHandler handlerAbove = (IItemHandler)capabilityAbove.resolve().get();
                for (int i = 0; i < handlerAbove.getSlots(); ++i) {
                    int slot;
                    ItemStack stack = handlerAbove.getStackInSlot(i);
                    if (!QuarryContainer.burnables.contains(stack.m_41720_()) || (slot = this.hasInputSpace(new ItemStack((ItemLike)stack.m_41720_(), 1))) == -1 || slot == 99) continue;
                    quarryHandler.insertItem(slot, new ItemStack((ItemLike)stack.m_41720_(), 1), false);
                    handlerAbove.extractItem(i, 1, false);
                }
            }
        }
    }

    private void exportImportBelow(IItemHandler quarryHandler, boolean out) {
        BlockEntity tileBelow = this.f_58857_.m_7702_(this.m_58899_().m_7495_());
        if (tileBelow != null) {
            LazyOptional capabilityBelow = tileBelow.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (out && capabilityBelow.isPresent()) {
                IItemHandler handlerBelow = (IItemHandler)capabilityBelow.resolve().get();
                boolean doBreak = false;
                for (int i = 6; i <= 11; ++i) {
                    ItemStack stack = quarryHandler.getStackInSlot(i);
                    for (int e = 0; e < handlerBelow.getSlots(); ++e) {
                        ItemStack slotStack = handlerBelow.getStackInSlot(e);
                        if (stack.m_150930_(Items.f_41852_) || !slotStack.m_41619_() && !new ItemStack((ItemLike)stack.m_41720_(), 1).m_150930_(slotStack.m_41720_()) || slotStack.m_41613_() + 1 > stack.m_41741_()) continue;
                        handlerBelow.insertItem(e, new ItemStack((ItemLike)stack.m_41720_(), 1), false);
                        quarryHandler.extractItem(i, 1, false);
                        doBreak = true;
                        break;
                    }
                    if (doBreak) break;
                }
            }
        }
    }

    public void tick() {
        CompoundTag itemTag;
        ItemStack areaCardItem;
        int i;
        BlockState right;
        if (this.f_58857_.f_46443_) {
            return;
        }
        QuarryBlockEntity entity = this;
        Level level = this.m_58904_();
        BlockState state = this.m_58900_();
        BlockState above = level.m_8055_(this.m_58899_().m_7494_());
        BlockState below = level.m_8055_(this.m_58899_().m_7495_());
        switch ((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)) {
            case NORTH: {
                BlockState blockState = level.m_8055_(this.m_58899_().m_122024_());
                break;
            }
            case EAST: {
                BlockState blockState = level.m_8055_(this.m_58899_().m_122012_());
                break;
            }
            case SOUTH: {
                BlockState blockState = level.m_8055_(this.m_58899_().m_122029_());
                break;
            }
            default: {
                BlockState blockState = right = level.m_8055_(this.m_58899_().m_122019_());
            }
        }
        if (level.m_46467_() % 2L == 0L) {
            boolean in = false;
            boolean out = false;
            if (level.m_46467_() % 4L == 0L) {
                level.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 3);
            }
            switch (this.getEject()) {
                case 1: {
                    in = true;
                    break;
                }
                case 2: {
                    out = true;
                    break;
                }
                case 3: {
                    in = true;
                    out = true;
                }
            }
            LazyOptional quarryCapability = this.getCapability(ForgeCapabilities.ITEM_HANDLER);
            if (quarryCapability.isPresent()) {
                IItemHandler quarryHandler = (IItemHandler)quarryCapability.resolve().get();
                if (right.m_155947_()) {
                    this.exportImportRightSide(quarryHandler, in);
                }
                if (above.m_155947_()) {
                    this.exportImportAbove(quarryHandler, in);
                }
                if (below.m_155947_()) {
                    this.exportImportBelow(quarryHandler, out);
                }
            }
        }
        ArrayList<ItemStack> input = new ArrayList<ItemStack>();
        for (i = 0; i <= 5; ++i) {
            input.add(this.m_8020_(i));
        }
        if (this.burnTime <= 1001) {
            for (i = 0; i < input.size(); ++i) {
                if (ForgeHooks.getBurnTime((ItemStack)((ItemStack)input.get(i)), null) <= 0) continue;
                if (((ItemStack)input.get(i)).m_41720_().m_41470_()) {
                    int output = this.hasOutputSpace(new ItemStack((ItemLike)((ItemStack)input.get(i)).m_41720_().m_41469_(), 1));
                    if (output == 99) break;
                    this.totalBurnTime = this.burnTime + ForgeHooks.getBurnTime((ItemStack)((ItemStack)input.get(i)), null);
                    this.burnTime += this.totalBurnTime;
                    this.m_6836_(output, new ItemStack((ItemLike)((ItemStack)input.get(i)).m_41720_().m_41469_(), this.m_8020_(output).m_41613_() + 1));
                    this.m_7407_(i, 1);
                    break;
                }
                this.totalBurnTime = this.burnTime + ForgeHooks.getBurnTime((ItemStack)((ItemStack)input.get(i)), null);
                this.burnTime += this.totalBurnTime;
                this.m_7407_(i, 1);
                break;
            }
        }
        if (this.burnTime > 0 != (Boolean)state.m_61143_((Property)QuarryBlock.POWERED)) {
            level.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)QuarryBlock.POWERED, (Comparable)Boolean.valueOf(this.burnTime > 0)));
        }
        if (!((Boolean)state.m_61143_((Property)QuarryBlock.POWERED)).booleanValue() && ((Boolean)state.m_61143_((Property)QuarryBlock.ACTIVE)).booleanValue()) {
            level.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)QuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(this.burnTime > 0)));
        }
        if (!((Boolean)state.m_61143_((Property)QuarryBlock.ACTIVE)).booleanValue() && ((Boolean)state.m_61143_((Property)QuarryBlock.WORKING)).booleanValue()) {
            level.m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)QuarryBlock.POWERED, (Comparable)Boolean.valueOf(this.burnTime > 0))).m_61124_((Property)QuarryBlock.WORKING, (Comparable)Boolean.valueOf(false)));
        }
        if (this.burnTime >= (Integer)CommonConfig.quarryIdleConsumption.get() && this.burnTicks >= 20 && !((Boolean)state.m_61143_((Property)QuarryBlock.WORKING)).booleanValue()) {
            this.burnTime -= ((Integer)CommonConfig.quarryIdleConsumption.get()).intValue();
            this.burnTicks = 0;
        }
        ++this.burnTicks;
        if (((Boolean)state.m_61143_((Property)QuarryBlock.ACTIVE)).booleanValue() && (areaCardItem = this.m_8020_(12)).m_150930_((Item)ModItems.AREA_CARD.get()) && (itemTag = NbtUtil.getNbtTag(areaCardItem)).m_128441_("pos1") && itemTag.m_128441_("pos2")) {
            boolean isSilktouch;
            boolean speedy;
            boolean bl = speedy = this.speed == 0 && this.ticks + this.speedModifier < 15;
            if (this.speed == 1 && this.ticks + this.speedModifier < 10) {
                speedy = true;
            }
            if (this.speed == 2 && this.ticks + this.speedModifier < 5) {
                speedy = true;
            }
            if (this.speed == 3 && this.ticks + this.speedModifier < 2) {
                speedy = true;
            }
            float fuelModifier = CalcUtil.getNeededTicks(this.mode, this.speed);
            boolean isVoid = switch (entity.getMode()) {
                case 1 -> {
                    this.speedModifier = -5;
                    this.isFortune = false;
                    isSilktouch = false;
                    yield false;
                }
                case 2 -> {
                    this.speedModifier = 0;
                    this.isFortune = true;
                    isSilktouch = false;
                    yield false;
                }
                case 3 -> {
                    this.speedModifier = 0;
                    this.isFortune = false;
                    isSilktouch = true;
                    yield false;
                }
                case 4 -> {
                    this.speedModifier = 0;
                    this.isFortune = false;
                    isSilktouch = false;
                    yield true;
                }
                default -> {
                    this.speedModifier = 0;
                    this.isFortune = false;
                    isSilktouch = false;
                    yield false;
                }
            };
            if (this.blockStateList == null || this.blockStateList.isEmpty()) {
                this.refreshPositions(areaCardItem);
            }
            if (this.blockStateList.size() > 0 && (float)this.burnTime > fuelModifier) {
                int blockIndex;
                if (areaCardItem.m_150930_((Item)ModItems.AREA_CARD.get())) {
                    level.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)QuarryBlock.WORKING, (Comparable)Boolean.valueOf(true)));
                }
                if (!itemTag.m_128441_("lastBlock")) {
                    itemTag.m_128405_("lastBlock", 0);
                }
                if ((blockIndex = itemTag.m_128451_("lastBlock")) > this.blockStateList.size() - 1) {
                    level.m_46597_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)QuarryBlock.WORKING, (Comparable)Boolean.valueOf(false))).m_61124_((Property)QuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(false)));
                    itemTag.m_128405_("lastBlock", 0);
                    if (this.getLoop()) {
                        level.m_46597_(this.m_58899_(), (BlockState)state.m_61124_((Property)QuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
                    }
                    return;
                }
                BlockPos currentBlock = this.blockStateList.get(blockIndex);
                if (this.isInNearSquare(this.m_58899_(), currentBlock)) {
                    itemTag.m_128405_("lastBlock", blockIndex + 1);
                    itemTag.m_128405_("currentY", currentBlock.m_123342_());
                    return;
                }
                if (speedy) {
                    ++this.ticks;
                    return;
                }
                if (entity.getSkip() && level.m_8055_(currentBlock).m_60734_() == Blocks.f_50016_) {
                    itemTag.m_128405_("lastBlock", blockIndex + 1);
                    itemTag.m_128405_("currentY", currentBlock.m_123342_());
                    ++this.ticks;
                    return;
                }
                if (level.m_8055_(currentBlock).m_60734_() == Blocks.f_50016_) {
                    itemTag.m_128405_("lastBlock", blockIndex + 1);
                    itemTag.m_128405_("currentY", currentBlock.m_123342_());
                    this.burnTime = (int)((float)this.burnTime - fuelModifier);
                } else {
                    FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)new GameProfile(UUID.fromString("6e483f02-30db-4454-b612-3a167614b576"), "VanillaQuarry Quarry"));
                    List drops = level.m_8055_(currentBlock).m_60724_(this.getBuilder(level, currentBlock, isSilktouch));
                    if (drops.isEmpty()) {
                        if (this.allowedToBreak(level.m_8055_(currentBlock), level, currentBlock, (Player)player)) {
                            this.m_6596_();
                            level.m_6263_((Player)player, (double)currentBlock.m_123341_() + 0.5, (double)currentBlock.m_123342_() + 0.5, (double)currentBlock.m_123343_() + 0.5, level.m_8055_(currentBlock).m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            level.m_7731_(currentBlock, Blocks.f_50016_.m_49966_(), 3);
                        }
                        itemTag.m_128405_("lastBlock", blockIndex + 1);
                        itemTag.m_128405_("currentY", currentBlock.m_123342_());
                        this.burnTime = (int)((float)this.burnTime - fuelModifier);
                        return;
                    }
                    boolean broken = false;
                    for (ItemStack drop : drops) {
                        if (isVoid) {
                            itemTag.m_128405_("lastBlock", blockIndex + 1);
                            itemTag.m_128405_("currentY", currentBlock.m_123342_());
                            this.burnTime = (int)((float)this.burnTime - fuelModifier);
                            broken = true;
                            break;
                        }
                        this.m_6596_();
                        int index = this.hasOutputSpace(drop);
                        if (index == 0) continue;
                        CompoundTag filtersTag = itemTag.m_128469_("Filters");
                        boolean filtered = false;
                        Item[] stacks = new Item[]{Items.f_42594_, Items.f_41905_, Items.f_41832_, Items.f_42329_, Items.f_41830_, Items.f_41831_, Items.f_42048_};
                        if (this.getFilter()) {
                            for (int i2 = 0; i2 <= 6; ++i2) {
                                if (!filtersTag.m_128471_(String.valueOf(i2)) || !drop.m_150930_(stacks[i2])) continue;
                                filtered = true;
                            }
                        }
                        if (this.allowedToBreak(level.m_8055_(currentBlock), level, currentBlock, (Player)player)) {
                            if (!filtered) {
                                this.m_6836_(index, new ItemStack((ItemLike)drop.m_41720_(), this.m_8020_(index).m_41613_() + drop.m_41613_()));
                            }
                            this.burnTime = (int)((float)this.burnTime - fuelModifier);
                            broken = true;
                        }
                        itemTag.m_128405_("lastBlock", blockIndex + 1);
                        itemTag.m_128405_("currentY", currentBlock.m_123342_());
                        break;
                    }
                    if (broken) {
                        BlockPos[] positions;
                        ItemStack drop;
                        level.m_6263_((Player)player, (double)currentBlock.m_123341_() + 0.5, (double)currentBlock.m_123342_() + 0.5, (double)currentBlock.m_123343_() + 0.5, level.m_8055_(currentBlock).m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        drop = this.m_8020_(13).m_41720_();
                        if (drop instanceof BlockItem) {
                            BlockItem blockItem = (BlockItem)drop;
                            ItemStack inputItem = this.m_8020_(13);
                            inputItem.m_41774_(1);
                            this.m_6836_(13, inputItem);
                            level.m_6263_((Player)player, (double)currentBlock.m_123341_() + 0.5, (double)currentBlock.m_123342_() + 0.5, (double)currentBlock.m_123343_() + 0.5, blockItem.m_40614_().m_49966_().m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                            level.m_7731_(currentBlock, blockItem.m_40614_().m_49966_(), 3);
                        } else {
                            level.m_5898_((Player)player, 2001, currentBlock, Block.m_49956_((BlockState)level.m_8055_(currentBlock)));
                            level.m_7731_(currentBlock, Blocks.f_50016_.m_49966_(), 3);
                        }
                        for (BlockPos pos : positions = new BlockPos[]{currentBlock.m_122012_(), currentBlock.m_122029_(), currentBlock.m_122019_(), currentBlock.m_122024_(), currentBlock.m_7494_(), currentBlock.m_7495_()}) {
                            if (!level.m_8055_(pos).m_60819_().m_76170_()) continue;
                            level.m_7731_(pos, Blocks.f_50652_.m_49966_(), 3);
                            level.m_6263_((Player)player, (double)currentBlock.m_123341_() + 0.5, (double)currentBlock.m_123342_() + 0.5, (double)currentBlock.m_123343_() + 0.5, Blocks.f_50652_.m_49966_().m_60827_().m_56775_(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                }
            } else {
                level.m_7731_(this.m_58899_(), (BlockState)((BlockState)state.m_61124_((Property)QuarryBlock.ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)QuarryBlock.WORKING, (Comparable)Boolean.valueOf(false)), 3);
            }
            this.ticks = 0;
        }
    }

    public boolean isInNearSquare(BlockPos origin, BlockPos target) {
        BlockPos pos1 = origin.m_7918_(-1, -1, -1);
        BlockPos pos2 = origin.m_7918_(1, 1, 1);
        return CalcUtil.getBlockStates(pos1, pos2, this.f_58857_).contains(target);
    }

    public int hasInputSpace(ItemStack itemStack) {
        for (int i = 0; i <= 5; ++i) {
            ItemStack current = this.m_8020_(i);
            if (itemStack.m_150930_(Items.f_41852_)) {
                return 0;
            }
            if (current.m_41619_()) {
                return i;
            }
            if (current.m_41720_() != itemStack.m_41720_() || current.m_41613_() + itemStack.m_41613_() > current.m_41741_()) continue;
            return i;
        }
        return -1;
    }

    public int hasOutputSpace(ItemStack itemStack) {
        for (int i = 6; i <= 11; ++i) {
            ItemStack current = this.m_8020_(i);
            if (itemStack.m_150930_(Items.f_41852_)) {
                return 0;
            }
            if (current.m_41619_()) {
                return i;
            }
            if (current.m_41720_() != itemStack.m_41720_() || current.m_41613_() + itemStack.m_41613_() > current.m_41741_()) continue;
            return i;
        }
        return 0;
    }

    private boolean allowedToBreak(BlockState state, Level world, BlockPos pos, Player player) {
        if (!state.m_60734_().canEntityDestroy(state, (BlockGetter)world, pos, (Entity)player) || state.m_60800_((BlockGetter)this.f_58857_, pos) == -1.0f) {
            return false;
        }
        BlockEvent.BreakEvent event = new BlockEvent.BreakEvent(world, pos, state, player);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return !event.isCanceled();
    }

    public void resetPositions() {
        this.blockStateList = null;
    }

    public void refreshPositions(ItemStack itemStack) {
        CompoundTag pos1 = (CompoundTag)itemStack.m_41784_().m_128423_("pos1");
        CompoundTag pos2 = (CompoundTag)itemStack.m_41784_().m_128423_("pos2");
        if (pos1 == null || pos2 == null) {
            return;
        }
        BlockPos blockPos1 = NbtUtil.getPos(pos1);
        BlockPos blockPos2 = NbtUtil.getPos(pos2);
        this.blockStateList = CalcUtil.getBlockStates(blockPos2, blockPos1, this.f_58857_);
    }

    public LootContext.Builder getBuilder(Level level, BlockPos pos, boolean isSilktouch) {
        ItemStack stack = new ItemStack((ItemLike)Items.f_42398_);
        if (isSilktouch) {
            stack.m_41663_(Enchantments.f_44985_, 1);
        }
        if (this.isFortune) {
            stack.m_41663_(Enchantments.f_44987_, 3);
        }
        this.lootcontextBuilder = new LootContext.Builder((ServerLevel)level).m_230911_(level.f_46441_).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)stack).m_78984_(LootContextParams.f_81462_, (Object)this);
        return this.lootcontextBuilder;
    }

    public int getSpeed() {
        return this.speed;
    }

    public void setSpeed(int speed) {
        this.speed = speed;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public int getBurnTime() {
        return this.burnTime;
    }

    public void setBurnTime(int burnTime) {
        this.burnTime = burnTime;
    }

    public int getTotalBurnTime() {
        return this.totalBurnTime;
    }

    public void setTotalBurnTime(int totalBurnTime) {
        this.totalBurnTime = totalBurnTime;
    }

    public Level m_58904_() {
        return super.m_58904_();
    }

    public void m_142339_(@NotNull Level pLevel) {
        super.m_142339_(pLevel);
    }

    public String getOwner() {
        return this.owner == null ? "undefined" : this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public boolean getLocked() {
        return this.locked;
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public int getEject() {
        return this.eject;
    }

    public void setEject(int eject) {
        this.eject = eject;
    }

    public boolean getFilter() {
        return this.filter;
    }

    public void setFilter(boolean filter) {
        this.filter = filter;
    }

    public boolean getLoop() {
        return this.loop;
    }

    public void setLoop(boolean loop) {
        this.loop = loop;
    }

    public boolean getSkip() {
        return this.skip;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    @NotNull
    public CompoundTag m_5995_() {
        super.m_5995_();
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("BurnTime", this.getBurnTime());
        nbt.m_128405_("TotalBurnTime", this.getTotalBurnTime());
        nbt.m_128405_("Speed", this.getSpeed());
        nbt.m_128405_("Mode", this.getMode());
        nbt.m_128405_("Eject", this.getEject());
        nbt.m_128359_("Owner", this.getOwner());
        nbt.m_128379_("Locked", this.getLocked());
        nbt.m_128379_("Filter", this.getFilter());
        nbt.m_128379_("Loop", this.getLoop());
        nbt.m_128379_("Skip", this.getSkip());
        return nbt;
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.setBurnTime(tag.m_128451_("BurnTime"));
        this.setTotalBurnTime(tag.m_128451_("TotalBurnTime"));
        this.setSpeed(tag.m_128451_("Speed"));
        this.setMode(tag.m_128451_("Mode"));
        this.setEject(tag.m_128451_("Eject"));
        this.setOwner(tag.m_128461_("Owner"));
        this.setLocked(tag.m_128471_("Locked"));
        this.setFilter(tag.m_128471_("Filter"));
        this.setLoop(tag.m_128471_("Loop"));
        this.setSkip(tag.m_128471_("Skip"));
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        if (this.m_58904_().f_46443_ && net.getDirection() == PacketFlow.CLIENTBOUND) {
            this.handleUpdateTag(pkt.m_131708_());
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_183515_(@NotNull CompoundTag nbt) {
        super.m_183515_(nbt);
        nbt.m_128405_("Speed", this.speed);
        nbt.m_128405_("Mode", this.mode);
        nbt.m_128405_("Eject", this.eject);
        nbt.m_128405_("BurnTime", this.burnTime);
        nbt.m_128405_("TotalBurnTime", this.totalBurnTime);
        nbt.m_128359_("Owner", this.getOwner());
        nbt.m_128379_("Locked", this.getLocked());
        nbt.m_128379_("Filter", this.getFilter());
        nbt.m_128379_("Loop", this.getLoop());
        nbt.m_128379_("Skip", this.getSkip());
        ContainerHelper.m_18976_((CompoundTag)nbt, this.items, (boolean)true);
    }

    public void m_142466_(@NotNull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.items.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.items);
        this.speed = nbt.m_128451_("Speed");
        this.mode = nbt.m_128451_("Mode");
        this.eject = nbt.m_128451_("Eject");
        this.burnTime = nbt.m_128451_("BurnTime");
        this.totalBurnTime = nbt.m_128451_("TotalBurnTime");
        this.owner = nbt.m_128461_("Owner");
        this.locked = nbt.m_128471_("Locked");
        this.filter = nbt.m_128471_("Filter");
        this.loop = nbt.m_128471_("Loop");
        this.skip = nbt.m_128471_("Skip");
    }

    public int @NotNull [] m_7071_(@NotNull Direction pSide) {
        if (pSide == Direction.DOWN) {
            return new int[]{6, 7, 8, 9, 10, 11};
        }
        if (pSide == Direction.UP) {
            return new int[]{0, 1, 2, 3, 4, 5};
        }
        switch ((Direction)this.m_58900_().m_61143_((Property)QuarryBlock.FACING)) {
            case NORTH: {
                if (pSide != Direction.WEST) break;
                return new int[]{13};
            }
            case EAST: {
                if (pSide != Direction.NORTH) break;
                return new int[]{13};
            }
            case SOUTH: {
                if (pSide != Direction.EAST) break;
                return new int[]{13};
            }
            default: {
                if (pSide != Direction.SOUTH) break;
                return new int[]{13};
            }
        }
        return new int[0];
    }

    public boolean m_7155_(int pIndex, @NotNull ItemStack pItemStack, @Nullable Direction pDirection) {
        if (pDirection == Direction.DOWN) {
            return false;
        }
        if (pDirection == Direction.UP) {
            return ForgeHooks.getBurnTime((ItemStack)pItemStack, null) > 0;
        }
        return pItemStack.m_41720_() instanceof BlockItem;
    }

    public boolean m_7157_(int pIndex, @NotNull ItemStack pStack, @NotNull Direction pDirection) {
        return pDirection == Direction.DOWN;
    }

    @NotNull
    protected Component m_6820_() {
        return Component.m_237115_((String)"block.quarry.quarry_block");
    }

    @NotNull
    protected AbstractContainerMenu m_6555_(int pContainerId, @NotNull Inventory pInventory) {
        return new QuarryContainer(pContainerId, pInventory, this.m_58899_(), this.m_58904_());
    }

    public int m_6643_() {
        return 14;
    }

    public boolean m_7983_() {
        for (ItemStack itemStack : this.items) {
            if (!itemStack.m_41619_()) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public ItemStack m_8020_(int index) {
        if (index < 0 || index >= this.items.size()) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)this.items.get(index);
    }

    @NotNull
    public ItemStack m_7407_(int index, int count) {
        return ContainerHelper.m_18969_(this.items, (int)index, (int)count);
    }

    @NotNull
    public ItemStack m_8016_(int index) {
        return ContainerHelper.m_18966_(this.items, (int)index);
    }

    public void m_6836_(int index, @NotNull ItemStack stack) {
        this.items.set(index, (Object)stack);
        if (stack.m_41613_() > this.m_6893_()) {
            stack.m_41764_(this.m_6893_());
        }
    }

    public boolean m_6542_(Player player) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    public void m_6211_() {
        this.items.clear();
    }
}

